#include "General.h"
#include "SBHNoRemotePickup.h"
#include "PhysicalGameObj.h"
#include "PowerupGameObj.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define GREEN "104,234,40"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

SBHNoRemotePickup::SBHNoRemotePickup()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

SBHNoRemotePickup::~SBHNoRemotePickup()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void SBHNoRemotePickup::OnObjectCreate(void *data,GameObject *obj)
{
	if (obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_PowerUpGameObj())
	{
		const char* PowerupPreset = Commands->Get_Preset_Name(obj);
		if ( !strcmp(PowerupPreset,"CnC_POW_MineRemote_02") ) 
		{
			Attach_Script_Once(obj,"Iran_No_SBH_Remote_C4","");
		}
	}
}

void Iran_No_SBH_Remote_C4::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == 1000000025 && Commands->Is_A_Star(sender))
	{
		int PlayerID = Get_Player_ID(sender);
		if (strcmp(Commands->Get_Preset_Name(sender),"CnC_Nod_FlameThrower_2SF") == 0)
		{
			if (strcmp(Commands->Get_Preset_Name(obj),"CnC_POW_MineRemote_02") == 0)
			{
				Remove_Weapon(sender,"CnC_Weapon_MineRemote_Player_2Max");
				Page(PlayerID, GREEN, "Stealth Black Hands are no longer able to pick up Remote C4 on this server.");
			}
		}
	}
}

ScriptRegistrant<Iran_No_SBH_Remote_C4> Iran_No_SBH_Remote_C4_Registrant("Iran_No_SBH_Remote_C4","");

SBHNoRemotePickup sBHNoRemotePickup;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &sBHNoRemotePickup;
}
